
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Page"
	Flip : WaitKey ( )
#ENDIF

Declare Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, __P_Index As Long = 0 ) As Story_Page_Type

Declare Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Entity_Direct ( Page As Story_Page_Type, __E_Index As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Options_Direct ( Page As Story_Page_Type, __O_Index As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Desc_Direct ( Page As Story_Page_Type, __D_Index As Long = 0, Buffer As String = "" ) As String

Declare Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Direct ( Page As Story_Page_Type, __P_Index As Long = 1, Buffer As String = "" ) As String

Declare Function Encounter ( Page As Story_Page_Type, __E_Index As Long = 0 ) As String

Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, __P_Index As Long = 0 ) As Story_Page_Type

	Dim As String CI : CI = ""

	Dim As Story_Page_Type Page
	
	Dim As String PreBuffer

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	

	'Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""
	
	__S_Buffer = ""
	__Q_Buffer = ""

	'With Page

		Page .Index = __P_Index
		
		Page .Buffer = Allocate_Page_Direct ( Page, __P_Index, "" )

		__S_Buffer = ""
		__Q_Buffer = Page .Buffer

		CI = SimpleWait ( "Buffer=" & "<" & CRLF & Page .Buffer & CRLF & ">", RGBA ( 196, 255, 160, 255 ) )

		'__Set ( Page_DB ( ), __P_Index, "Index", Page .Index )
		'__Set ( Page_DB ( ), __P_Index, "Filename", Page .Filename )
		
		__P_Buffer = Buffer_Section ( __Q_Buffer, 1, 2 )
		
			CI = SimpleWait ( "Allocate" & VARSEP & "Page" & VARSEP & "Buffer=" & "<" & CRLF & __P_Buffer & CRLF & ">", RGBA ( 196, 255, 160, 255 ) )
			
			Allocate_Page_Header ( Page_DB ( ), Page, __P_Buffer )

		__E_Buffer = Buffer_Section ( __Q_Buffer, 1, Page .A )
					
			__E_Index = 1
				
			__Q_Buffer = __E_Buffer
				
			Do While Len ( __Q_Buffer ) > 0
				
				__S_Buffer = Prefix ( CRLF, __Q_Buffer )
				
				CI = SimpleWait ( "Allocate" & VARSEP & "Entity" & VARSEP & __E_Index & VARSEP & "Buffer=" & "<" & CRLF & __S_Buffer & CRLF & ">", RGBA ( 196, 255, 160, 255 ) )
				
				__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
				
				Allocate_Entity_Direct ( Page, __E_Index, __S_Buffer )
				
				Encounter ( Page, __E_Index )
				
				If Len ( __Q_Buffer ) > 0 Then
				
					__E_Index += 1

				End If

			Loop
				
			'Allocate_Page_Entities ( Page_DB ( ), Page, __E_Buffer )

		__O_Buffer = Buffer_Section ( __Q_Buffer, 1, 4 )
					
			__O_Index = 1
				
			__Q_Buffer = __O_Buffer
			
			Do While Len ( __Q_Buffer ) > 0
				
				__S_Buffer = Prefix ( CRLF, __Q_Buffer )
				
				CI = SimpleWait ( "Allocate" & VARSEP & "Option" & VARSEP & __O_Index & VARSEP & "Buffer=" & "<" & CRLF & __S_Buffer & CRLF & ">", RGBA ( 196, 255, 160, 255 ) )
				
				__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
				
				Allocate_Options_Direct ( Page, __O_Index, __S_Buffer )
				
				If Len ( __Q_Buffer ) > 0 Then
				
					__O_Index += 1

				End If

			Loop
				
			'Allocate_Page_Options ( Page_DB ( ), Page, __O_Buffer )
		
		__D_Buffer = Buffer_Section ( __Q_Buffer, 1, 4 )
					
			__D_Index = 1
				
			__Q_Buffer = __D_Buffer
				
			Do While Len ( __Q_Buffer ) > 0
				
				__S_Buffer = Prefix ( CRLF, __Q_Buffer )
				
				CI = SimpleWait ( "Allocate" & VARSEP & "Desc" & VARSEP & __D_Index & VARSEP & "Buffer=" & "<" & CRLF & __S_Buffer & CRLF & ">", RGBA ( 196, 255, 160, 255 ) )
				
				__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
				
				Allocate_Desc_Direct ( Page, __D_Index, __S_Buffer )
				
				If Len ( __Q_Buffer ) > 0 Then
				
					__D_Index += 1

				End If

			Loop
				
			'Allocate_Page_Desc ( Page_DB ( ), Page, __D_Buffer )
		
	'End With
	
	Return Page
	
End Function


Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	'SimpleWait ( "Allocate_Page_Header" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )
	
	__S_Buffer = ""
	__Q_Buffer = Buffer
		
	'With Page
					
		__P_Index = Page .Index
		
		Allocate_Header_Direct ( Page, __Q_Buffer )
		
		'__Set ( Page_DB ( ), __P_Index, "Caption", Page .Caption )
		'__Set ( Page_DB ( ), __P_Index, "A", Page .A )
		'__Set ( Page_DB ( ), __P_Index, "B", Page .B )
		'__Set ( Page_DB ( ), __P_Index, "Sprite", Page .Sprite )
	
	'End With
		
	Return __Q_Buffer
	
End Function

Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
		
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	Dim As String Msg
	Msg = ""
	
	'SimpleWait ( "Allocate_Page_Entities" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	__S_Buffer = ""
	__Q_Buffer = Buffer
	
	'With Page
		
		__P_Index = Page .Index

		'__Set ( Page_DB ( ), __P_Index, "Caption", Page .Caption )
		'__Set ( Page_DB ( ), __P_Index, "A", Page .A )
		'__Set ( Page_DB ( ), __P_Index, "B", Page .B )
		'__Set ( Page_DB ( ), __P_Index, "Sprite", Page .Sprite )
	
		If Page .A = 0 Then
			
			Msg &= CRLF & "Erase" & SP & ".Entity"

			SimpleWait ( Msg , RGBA ( 255,0, 0, 255 ) )
			
			Erase Page .Entity
			
			Return ""
			
		Else
			
			Msg &= CRLF & "ReDim Preserve" & SP & ".Entity" & SP & "(" & SP & "1" & SP & "To" & SP & Page .A & SP & ")"
			
			ReDim Preserve Page .Entity ( 1 To Page .A )
		
		End If
		
		
		Msg &= CRLF & ".Entity" & VARSEP & "LBound=" & LBound( Page .Entity, 1 )
		
		Msg &= CRLF & ".Entity" & VARSEP & "UBound=" & UBound( Page .Entity, 1 )
		
		SimpleWait ( Msg , RGBA ( 255, 160, 64, 255 ) )
		
		/' [ ! ] hangs on the below line '/
		
		'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & "LBound", LBound( ( Page .Entity ), 1 ) )
		'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & "UBound", UBound( ( Page .Entity ) , 1 ) )
				
		For __E_Index = 1 To UBound ( Page .Entity, 1 ) Step 1
			
			Msg = "For " & __E_Index & " As Long = 1 To " & UBound ( Page .Entity, 1 ) & " Step 1"
		
			SimpleWait ( Msg , RGBA ( 255, 160, 64, 255 ) )
			
			Allocate_Entity_Direct ( Page, __E_Index, __Q_Buffer )

			'With Page .Entity ( __E_Index )

				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Active", Page .Entity ( __E_Index ).Active )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Raw", Page .Entity ( __E_Index ).Raw )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Element", Page .Entity ( __E_Index ).Element )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Count", Page .Entity ( __E_Index ).Count )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Mode", Page .Entity ( __E_Index ).Mode )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "ID", Page .Entity ( __E_Index ).ID )
				
				'Page .Entity ( __E_Index ).Sprite = ImageDestroy2 ( Page .Entity ( __E_Index ).Sprite )
				'Page .Entity ( __E_Index ).Scaled = ImageDestroy2 ( Page .Entity ( __E_Index ).Scaled )

				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Sprite", Page .Entity ( __E_Index ).Sprite )
				'__Set ( Page_DB ( ), __P_Index, "Entity" & VARSEP & __E_Index & VARSEP & "Scaled", Page .Entity ( __E_Index ).Scaled )
							
			'End With
			
		Next __E_Index
		
	'End With

	Return __Q_Buffer
	
End Function

Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	'SimpleWait ( "Allocate_Page_Options" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	__S_Buffer = ""
	__Q_Buffer = Buffer

	'With Page

		__P_Index = Page .Index

		ReDim Page .Options ( 1 To 4 )		

		'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & "LBound", 1 )
		'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & "UBound", UBound( Page .Options, 1 ) )

		For __O_Index = 1 To UBound (  Page .Options, 1 ) Step 1
			
			SimpleWait ( "For " & __O_Index & " As Long = 1 To " & UBound ( Page .Options, 1 ) & " Step 1", RGBA ( 255, 160, 64, 255 ) )
			
			Allocate_Options_Direct ( Page, __O_Index, __Q_Buffer )

			'With .Options ( __O_Index )

				'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & __O_Index & VARSEP & "Key", Page .Options ( __O_Index ) .Key )
				'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & __O_Index & VARSEP & "Dest", Page .Options ( __O_Index ) .Dest )
				'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & __O_Index & VARSEP & "Req", Page .Options ( __O_Index ) .Req )
				'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & __O_Index & VARSEP & "Caption", Page .Options ( __O_Index ) .Caption )
				'__Set ( Page_DB ( ), __P_Index, "Options" & VARSEP & __O_Index & VARSEP & "Active", Page .Options ( __O_Index ) .Active )
			
			'End With

		Next __O_Index
	
	'End With
	
	Return __Q_Buffer
	
End Function

Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	'SimpleWait ( "Allocate_Page_Desc" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page .Index & CRLF & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	__S_Buffer = ""
	__Q_Buffer = Buffer

	'With Page

		__P_Index = Page .Index

		ReDim Page .Desc ( 1 To 4 )		

		'__Set ( Page_DB ( ), __P_Index, "Desc" & VARSEP & "LBound", 1 )
		'__Set ( Page_DB ( ), __P_Index, "Desc" & VARSEP & "UBound", UBound( Page .Desc, 1 ) )
		
		For __D_Index = 1 To UBound ( Page .Desc, 1 ) Step 1				
			
			Allocate_Desc_Direct ( Page, __D_Index, __Q_Buffer )
			
			'With Page .Desc ( __D_Index )

				'__Set ( Page_DB ( ), __P_Index, "Desc" & VARSEP & __D_Index & VARSEP & "Text", Page .Desc ( __D_Index ) .Text )
				'__Set ( Page_DB ( ), __P_Index, "Desc" & VARSEP & __D_Index & VARSEP & "Active", Page .Desc ( __D_Index ) .Active )
			
			'End With
			
		Next __D_Index

	'End With

	Return __Q_Buffer
	
End Function


Function Allocate_Entity_Direct ( Page As Story_Page_Type, __E_Index As Long = 0, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	'Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	Dim As String CI : CI = ""
		
	__S_Buffer = ""
	__Q_Buffer = Buffer

	'With Entity
		
		If __E_Index < 1 Or __E_Index > UBound ( Page .Entity, 1 ) Then
			Return __Q_Buffer
		End If

		__S_Buffer = Trim ( Prefix ( CRLF, __Q_Buffer ), QUOT )
		__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
		
		Page .Entity ( __E_Index ) .Raw = __S_Buffer
				
		Select Case StrPos ( EQ, Page .Entity ( __E_Index ) .Raw )
		Case 0
			Page .Entity ( __E_Index ) .Element = "npc"
			Page .Entity ( __E_Index ) .ID = Page .Entity ( __E_Index ) .Raw
		Case Is > 0
			Page .Entity ( __E_Index ) .Element = LCase ( Prefix ( EQ, Page .Entity ( __E_Index ) .Raw ) )
			Page .Entity ( __E_Index ) .ID = Suffix ( EQ, Page .Entity ( __E_Index ) .Raw )
		End Select
			
		Select Case StrPos ( COLON, Page .Entity ( __E_Index ) .ID )
		Case 0
			Page .Entity ( __E_Index ) .Count = 1
		Case Is > 0
			Page .Entity ( __E_Index ) .Count = ValInt ( Prefix ( COLON, Page .Entity ( __E_Index ) .ID ) )
			Page .Entity ( __E_Index ) .ID = UCWords ( Suffix ( COLON, Page .Entity ( __E_Index ) .ID ) )
		End Select
		
		Select Case StrPos ( SP, Page .Entity ( __E_Index ) .ID )
		Case 0
			Page .Entity ( __E_Index ) .Mode = "Normal"
			Page .Entity ( __E_Index ) .ID = UCWords ( Page .Entity ( __E_Index ) .ID )
		Case Is > 0
			Page .Entity ( __E_Index ) .Mode = UCWords ( Prefix ( SP, Page .Entity ( __E_Index ) .ID ) )
			Page .Entity ( __E_Index ) .ID = UCWords ( Suffix ( SP, Page .Entity ( __E_Index ) .ID ) )
		End Select
		
		Select Case Page .Entity ( __E_Index ) .Mode
		Case "Mad", "Dead", "Normal"
		Case Else
			Page .Entity ( __E_Index ) .ID = Page .Entity ( __E_Index ) .Mode & SP & Page .Entity ( __E_Index ) .ID
			Page .Entity ( __E_Index ) .Mode = "Normal"
		End Select
				
		Page .Entity ( __E_Index ) .Active = 0
		
	'End With
	
	Return __Q_Buffer
	
End Function


Function Allocate_Options_Direct ( Page As Story_Page_Type, __O_Index As Long = 0, Buffer As String = "" ) As String
	
	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	'Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	__S_Buffer = ""
	__Q_Buffer = Buffer

	'With Options

		__S_Buffer = Prefix ( CRLF, __Q_Buffer )
		__Q_Buffer = Suffix ( CRLF, __Q_Buffer )

		Page. Options ( __O_Index ) .Key = Trim ( Prefix ( COMMA, __S_Buffer ), QUOT )
		
		__S_Buffer = Suffix ( COMMA, __S_Buffer )
		Page. Options ( __O_Index ) .Dest = ValInt ( Trim ( Prefix ( COMMA, __S_Buffer ), QUOT ) )
		
		__S_Buffer = Suffix ( COMMA, __S_Buffer )
		Page. Options ( __O_Index ) .Req = ValInt ( Trim ( Prefix ( COMMA, __S_Buffer ), QUOT ) )
		
		__S_Buffer = Suffix( COMMA, __S_Buffer )
		Page. Options ( __O_Index ) .Caption = Trim ( __S_Buffer, QUOT )

		Page. Options ( __O_Index ) .Active = 0

		'__S_Buffer = ""
		'__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
	
	'End With
	
	Return __Q_Buffer
	
End Function


Function Allocate_Desc_Direct ( Page As Story_Page_Type, __D_Index As Long = 0, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	'Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	__S_Buffer = ""
	__Q_Buffer = Buffer

	'With Desc
		
		__S_Buffer = Prefix ( CRLF, __Q_Buffer )
		__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
			
		Page .Desc ( __D_Index ) .Text = Trim ( __S_Buffer, QUOT )
			
		If Len ( Page .Desc ( __D_Index ) .Text ) > 0 Then
			Page .Desc ( __D_Index ) .Active = 1
		Else
			Page .Desc ( __D_Index ) .Active = 0
		End If
			
		'__S_Buffer = Prefix ( CRLF, __Q_Buffer )
		'__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
			
	'End With

	Return __Q_Buffer
	
End Function

Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String
	
	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""
	
	__S_Buffer = ""
	__Q_Buffer = Buffer
		
	'With Page
			
		__S_Buffer = Prefix ( CRLF, __Q_Buffer )
		__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
		
		__P_Index = Page .Index
		
		Page .Caption = Trim ( __S_Buffer, QUOT )
	
		__S_Buffer = Prefix ( CRLF, __Q_Buffer )
		__Q_Buffer = Suffix ( CRLF, __Q_Buffer )
		
		Page .A = ValInt ( Prefix ( ",", __S_Buffer ) )
		__S_Buffer = Suffix ( ",", __S_Buffer )
		
		Page .B = ValInt ( Prefix ( ",", __S_Buffer ) )
		__S_Buffer = Suffix ( ",", __S_Buffer )

		Page .Sprite = Trim ( __S_Buffer, QUOT )
	
	'End With
		
	Return __Q_Buffer
	
End Function



Function Allocate_Page_Direct ( Page As Story_Page_Type, __P_Index As Long = 1, Buffer As String = "" ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	'Dim As Long __P_Index = 0
	Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	Dim As String CI : CI = ""

	__S_Buffer = ""
	__Q_Buffer = ""

	'With Page

		Page .Index = __P_Index
		
		Page .Filename = Str_Replace ( "/", "\", Gamepack .Root & Gamepack .Pack & "\Assets\Page\" & PageIndex ( Page .Index, 3 ) & ".seq" )
		
		If Is_File ( Page .Filename ) = 0 Then
			
			Page .Buffer = ""
		
		Else
			
			Page .Buffer = __Direct_Buffer ( Page .Filename ) 

		End If
		
	'End With

	Return Page .Buffer

End Function


Function Encounter ( Page As Story_Page_Type, __E_Index As Long = 0 ) As String

	Dim As String __S_Buffer
	Dim As String __Q_Buffer
	
	__S_Buffer = ""
	__Q_Buffer = ""
	
	Dim As Long __P_Index = 0
	'Dim As Long __E_Index = 0
	Dim As Long __O_Index = 0
	Dim As Long __D_Index = 0

	Dim As String __P_Buffer
	Dim As String __E_Buffer
	Dim As String __O_Buffer
	Dim As String __D_Buffer

	__P_Buffer = ""
	__E_Buffer = ""
	__O_Buffer = ""
	__D_Buffer = ""

	Dim As String CI : CI = ""
	
	Dim As String Msg = ""
	
	Msg &= "You have"
	
	Select Case Page .Entity ( __E_Index ) .Mode
	Case "Mad"
		Msg &= SP & "come face to face with"
	Case "Dead"
		Msg &= SP & "come across the corpse of"
	Case "Normal"
		Msg &= SP & "encountered"
	Case Else
		Msg &= SP & "encountered"
	End Select
		
	Select Case Page .Entity ( __E_Index ) .Count
	Case 1
  	Case Is > 1
		Msg &= SP & Page .Entity ( __E_Index ) .Count
	Case Else
		Msg &= ""
	End Select

	Select Case Page .Entity ( __E_Index ) .Mode
	Case "Mad", "Dead"
		Msg &= SP & LCase ( Page .Entity ( __E_Index ) .Mode )
	Case "Normal"		
		Msg &= ""
	Case Else
		Msg &= ""
	End Select
		
	Msg &= SP & UCWords ( Page .Entity ( __E_Index ) .ID )
		
	Select Case Page .Entity ( __E_Index ) .Mode
	Case "Mad"
		Msg &= SP & "!!"
	Case "Dead"
		Msg &= SP & ".."
	Case "Normal"
		Msg &= SP & "."
	Case Else
		Msg &= SP & "."		
	End Select
	
	CI = SimpleWait ( Msg )
	
	Return Msg
		
End Function
